def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        gripper = 'gripper'  # Assuming a single gripper
        drawer = 'drawer'  # Assuming a single drawer
        middle_pos = positions['middle']  # Position of the drawer handle
        anchor_pos = positions['anchor']  # Position of the drawer anchor

        # Step 1: Move to the middle position to pick the drawer
        print("[Task] Moving to middle position to pick the drawer.")
        move(env, 'initial_room', middle_pos)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, drawer, middle_pos, gripper)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Move to the anchor position
        print("[Task] Moving to anchor position.")
        move(env, middle_pos, anchor_pos)

        # Step 5: Place the drawer back
        print("[Task] Placing the drawer.")
        place(env, drawer, anchor_pos)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()