def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        drawer_pos = positions['drawer']
        gripper_pos = positions['gripper']
        object_pos = positions['object']  # Replace 'object' with the actual object name

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_pos)
        move(env, gripper_pos, drawer_pos)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        pick(env, 'drawer', drawer_pos, 'gripper')

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer")
        pull(env, 'gripper', 'drawer')

        # Step 4: Move to the object
        print("[Task] Moving to the object at:", object_pos)
        move(env, drawer_pos, object_pos)

        # Step 5: Pick the object
        print("[Task] Picking the object")
        pick(env, 'object', object_pos, 'gripper')

        # Step 6: Place the object
        print("[Task] Placing the object back")
        place(env, 'object', drawer_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()