def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'drawer1'
        gripper = 'gripper1'
        object1 = 'object1'
        object2 = 'object2'
        
        # Example positions (replace with actual positions from the environment)
        drawer_pos = positions[drawer]
        object1_pos = positions[object1]
        object2_pos = positions[object2]

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_pos)
        move(env, 'current_room', drawer_pos)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, drawer, drawer_pos, gripper)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Move to the first object
        print("[Task] Moving to the first object at:", object1_pos)
        move(env, drawer_pos, object1_pos)

        # Step 5: Pick the first object
        print("[Task] Picking the first object.")
        pick(env, object1, object1_pos, gripper)

        # Step 6: Move to the second object
        print("[Task] Moving to the second object at:", object2_pos)
        move(env, object1_pos, object2_pos)

        # Step 7: Place the first object at the second object's position
        print("[Task] Placing the first object at the second object's position.")
        place(env, object1, object2_pos)

        # Step 8: Complete the task
        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()