def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'room_a'  # Placeholder for the initial position of the robot

        # Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        move(env, initial_position, initial_position)

        # Pick the drawer
        print("[Task] Picking the drawer:", drawer)
        pick(env, drawer, initial_position, gripper)

        # Rotate the gripper to the required angle
        print("[Task] Rotating gripper to ninety degrees")
        rotate(env, gripper, 'zero_deg', 'ninety_deg')

        # Move to the side position of the drawer
        side_position = 'side_pos_1'  # Placeholder for the actual side position
        print("[Task] Moving to side position:", side_position)
        move_to_side(env, gripper, drawer, initial_position, side_position)

        # Move to the anchor position of the drawer
        anchor_position = 'anchor_pos_1'  # Placeholder for the actual anchor position
        print("[Task] Moving to anchor position:", anchor_position)
        move_to_anchor(env, gripper, drawer, side_position, anchor_position)

        # Pull the drawer open
        print("[Task] Pulling the drawer open:", drawer)
        pull(env, gripper, drawer)

        # Place the object (if any) back in the drawer or on the table
        print("[Task] Placing the object back in the drawer")
        place(env, drawer, initial_position)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()