def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and a gripper
        gripper = 'gripper'
        drawer = 'drawer'
        side_position = 'side_position'
        anchor_position = 'anchor_position'
        object_to_pick = 'object'

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        move(env, gripper, side_position, anchor_position)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, object_to_pick, anchor_position, gripper)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Place the object
        print("[Task] Placing the object.")
        place(env, object_to_pick, anchor_position)

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()