import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import pick, place, pull
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        _, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions for the drawers and the plate
        plate_pos = positions['plate']

        # Step 1: Pull the top drawer
        print("[Task] Pulling the top drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Task ended after pulling the top drawer!")
            return

        # Step 2: Pick up all tomatoes
        print("[Task] Picking up tomatoes.")
        for item in ['item1', 'item2', 'item3']:
            item_pos = positions[item]
            obs, reward, done = pick(env, task, item, item_pos)
            if done:
                print(f"[Task] Task ended after picking {item}!")
                return

        # Step 3: Place all tomatoes on the plate
        print("[Task] Placing tomatoes on the plate.")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")