def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'initial_pos'  # Placeholder for the robot's initial position
        side_position = 'side_pos'  # Placeholder for the side position of the drawer
        anchor_position = 'anchor_pos'  # Placeholder for the anchor position of the drawer

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position.")
        obs, reward, done = move(env, initial_position, 'target_room')
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to the correct angle.")
        obs, reward, done = rotate(env, task, target_quat='desired_quat')
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Move to the side position of the drawer
        print("[Task] Moving to the side position of the drawer.")
        obs, reward, done = move_to_side(gripper, drawer, initial_position, side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick_drawer(gripper, drawer, anchor_position)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 6: Place the object (if applicable)
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object_to_place', 'target_location')
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()