import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Importing predefined skills
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # === Execute the Plan ===
        # Step 1: Pull open any drawer that is not locked
        try:
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x', max_steps=100, threshold=0.01, timeout=10.0)
            if done:
                print("[Task] Drawer opened successfully!")
            else:
                print("[Task] Failed to open the drawer.")
        except Exception as e:
            print(f"[Task] Error during pull action: {e}")

        # Step 2: Place the first tomato onto the plate
        try:
            obs, reward, done = pick(env, task, target_pos=tomato1_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
            if done:
                print("[Task] Tomato 1 picked successfully!")
                obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
                if done:
                    print("[Task] Tomato 1 placed successfully!")
                else:
                    print("[Task] Failed to place Tomato 1.")
            else:
                print("[Task] Failed to pick Tomato 1.")
        except Exception as e:
            print(f"[Task] Error during picking Tomato 1: {e}")

        # Step 3: Place the second tomato onto the plate
        try:
            obs, reward, done = pick(env, task, target_pos=tomato2_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
            if done:
                print("[Task] Tomato 2 picked successfully!")
                obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
                if done:
                    print("[Task] Tomato 2 placed successfully!")
                else:
                    print("[Task] Failed to place Tomato 2.")
            else:
                print("[Task] Failed to pick Tomato 2.")
        except Exception as e:
            print(f"[Task] Error during picking Tomato 2: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()