def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = positions['initial_position']  # Placeholder for the robot's initial position
        target_position = positions['target_position']    # Placeholder for the target position

        # Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        obs, reward, done = move(env, initial_position, target_position)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Rotate the gripper to the desired angle
        target_quat = [0, 0, 0, 1]  # Placeholder for the target quaternion
        print("[Task] Rotating gripper to target orientation.")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object_1', target_position, gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, 'object_1', target_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()