def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'item1', 'item2', 'item3', and 'plate'
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        plate_pos = positions['plate']

        # Step 1: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Assuming the robot is already in rooma
        if done:
            print("[Task] Task ended while moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, 'item1', 'rooma')
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Assuming the plate is in roomb
        if done:
            print("[Task] Task ended while moving to plate!")
            return

        # Step 4: Place item1 on plate
        print("[Task] Placing item1 on plate...")
        obs, reward, done = place(env, 'item1', 'plate')
        if done:
            print("[Task] Task ended after placing item1 on plate!")
            return

        # Repeat similar steps for item2 and item3
        for item in ['item2', 'item3']:
            item_pos = positions[item]
            print(f"[Task] Moving to {item} at:", item_pos)
            obs, reward, done = move(env, 'roomb', 'roomb')  # Assuming the robot is in roomb
            if done:
                print(f"[Task] Task ended while moving to {item}!")
                return

            print(f"[Task] Picking {item}...")
            obs, reward, done = pick(env, item, 'roomb')
            if done:
                print(f"[Task] Task ended after picking {item}!")
                return

            print(f"[Task] Moving to plate at:", plate_pos)
            obs, reward, done = move(env, 'roomb', 'roomb')  # Assuming the plate is still in roomb
            if done:
                print(f"[Task] Task ended while moving to plate!")
                return

            print(f"[Task] Placing {item} on plate...")
            obs, reward, done = place(env, item, 'plate')
            if done:
                print(f"[Task] Task ended after placing {item} on plate!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()