def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we are looking for an object named 'ball'
        object_name = 'ball'
        object_position = positions.get(object_name)

        if object_position is None:
            print(f"[Task] {object_name} not found in the environment.")
            return

        # Move to the object's location
        print(f"[Task] Moving to {object_name} at:", object_position)
        obs, reward, done = move(env, 'current_room', 'object_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to the object!")
            return

        # Attempt to pick the object
        print(f"[Task] Attempting to pick {object_name}.")
        obs, reward, done = pick(env, task, target_pos=object_position, approach_distance=0.15)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to a new location to place the object
        new_location = 'new_room'  # Replace with actual room name
        print(f"[Task] Moving to place {object_name} at:", new_location)
        obs, reward, done = move(env, 'object_room', new_location)  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to place the object!")
            return

        # Place the object
        print(f"[Task] Placing {object_name} at {new_location}.")
        obs, reward, done = place(env, task, target_pos=new_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()