def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'ball1' in the environment
        target_object = 'ball1'
        if target_object not in positions:
            print(f"Error: Target object {target_object} not found in environment.")
            return

        target_pos = positions[target_object]
        print(f"[Task] Manipulating {target_object} at:", target_pos)

        # Check if the robot is at the correct location to pick the object
        robot_position = positions.get('robot', None)
        if robot_position is None:
            print("Error: Robot position not found.")
            return

        # Move robot to the object's location
        obs, reward, done = move(env, robot_position, target_pos)
        if done:
            print("[Task] Task ended during movement to object!")
            return

        # Attempt to pick the object
        obs, reward, done = pick(env, task, target_object, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Assuming we want to place the object in a different location, e.g., 'roomb'
        target_location = 'roomb'
        print(f"[Task] Placing {target_object} in {target_location}")

        # Move robot to the target location
        obs, reward, done = move(env, target_pos, target_location)
        if done:
            print("[Task] Task ended during movement to place object!")
            return

        # Place the object
        obs, reward, done = place(env, task, target_object, target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()