def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects based on the provided feedback
        valid_objects = ['item1', 'item2', 'plate']  # Update this list based on the actual objects in the environment

        # Example task plan
        for obj in valid_objects:
            if obj in positions:
                obj_pos = positions[obj]
                print(f"[Task] Manipulating {obj} at: {obj_pos}")

                # Approach and pick the object
                obs, reward, done = pick(
                    env,
                    task,
                    target_pos=obj_pos,
                    approach_distance=0.15,
                    max_steps=100,
                    threshold=0.01,
                    approach_axis='z',
                    timeout=10.0
                )
                
                if done:
                    print(f"[Task] Task ended after picking {obj}!")
                    return

                # Place the object at a designated location (for example, a drop-off point)
                drop_off_pos = (1.0, 1.0, 0.0)  # Example drop-off position
                print(f"[Task] Placing {obj} at: {drop_off_pos}")
                obs, reward, done = place(
                    env,
                    task,
                    target_pos=drop_off_pos
                )

                if done:
                    print(f"[Task] Task ended after placing {obj}!")
                    return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()