def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the object we want to manipulate is 'tomato1'
        tomato1_pos = positions['tomato1']  # Ensure 'tomato1' is in the object list

        # Check if the gripper is empty before picking
        obs = task.get_observation()
        if obs.handempty:
            print("[Task] Gripper is empty, proceeding to pick up tomato1.")
            # Move to the position of tomato1
            print(f"[Task] Moving to tomato1 at: {tomato1_pos}")
            # Assuming we have a move function to navigate to the object's position
            move(env, obs.robot_position, tomato1_pos)

            # Now pick up the tomato
            print("[Task] Picking up tomato1.")
            obs, reward, done = pick(env, task, target_pos=tomato1_pos)

            if done:
                print("[Task] Task ended after picking up tomato1!")
                return

        else:
            print("[Task] Gripper is not empty, cannot pick up tomato1.")

        # Assuming we want to place the tomato in a different location
        target_location = positions['target_location']  # Define the target location for placing
        print(f"[Task] Moving to target location at: {target_location}")
        move(env, obs.robot_position, target_location)

        print("[Task] Placing tomato1.")
        obs, reward, done = place(env, task, target_pos=target_location)

        if done:
            print("[Task] Task ended after placing tomato1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()