def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        plate_pos = positions['plate']
        rubbish_pos = positions['rubbish']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # Check if the objects are present before proceeding
        if not is_object_present(env, 'plate'):
            print("Plate is not present in the environment.")
            return
        if not is_object_present(env, 'rubbish'):
            print("Rubbish is not present in the environment.")
            return
        if not is_object_present(env, 'tomato1'):
            print("Tomato1 is not present in the environment.")
            return
        if not is_object_present(env, 'tomato2'):
            print("Tomato2 is not present in the environment.")
            return

        # Step 1: Pick up tomato1
        print("[Task] Picking up tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 2: Place tomato1 on the plate
        print("[Task] Placing tomato1 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 3: Pick up tomato2
        print("[Task] Picking up tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 4: Place tomato2 on the plate
        print("[Task] Placing tomato2 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

        # Step 5: Pick up rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 6: Place rubbish in a designated area (e.g., a bin)
        print("[Task] Placing rubbish in the designated area.")
        # Assuming designated area position is known
        designated_area_pos = (1, 1, 0)  # Example position
        obs, reward, done = place(env, task, target_pos=designated_area_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


def is_object_present(env, object_name):
    return object_name in env.get_objects()


if __name__ == "__main__":
    run_skeleton_task()