import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        table_pos = positions['table']
        plate_pos = (0, 0, 0)  # Replace with actual plate position if available

        # === Execute the Plan ===
        # Step 1: Pick tomato1 from the table
        print("[Task] Picking tomato1 from the table.")
        obs, _, _ = pick(env, task, target_pos=tomato1_pos)

        # Step 2: Place tomato1 on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, _, _ = place(env, task, target_pos=plate_pos)

        # Step 3: Pick tomato2 from the table
        print("[Task] Picking tomato2 from the table.")
        obs, _, _ = pick(env, task, target_pos=tomato2_pos)

        # Step 4: Place tomato2 on the plate
        print("[Task] Placing tomato2 on the plate.")
        obs, _, _ = place(env, task, target_pos=plate_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()