def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick and a room to place it in
        ball_pos = positions['ball1']  # Replace with actual object name
        room_pos = positions['rooma']   # Replace with actual room name

        # Check if the ball is at the correct position
        if 'ball1' in positions:
            print("[Task] Manipulating ball1 at:", ball_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=ball_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking ball1!")
                return

            # Now place the ball in the room
            print("[Task] Placing ball1 in rooma at:", room_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=room_pos
            )
            if done:
                print("[Task] Task ended after placing ball1!")
                return
        else:
            print("[Error] ball1 not found in the environment!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()