def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have a single object to pick and place
        object_pos = positions['object_1']  # Replace with actual object key

        # Step 1: Move to the object's location
        print("[Task] Moving to object location:", object_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=object_pos)
        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_pos)
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drop-off location (assuming a drop-off location is defined)
        drop_off_pos = positions['drop_off']  # Replace with actual drop-off location key
        print("[Task] Moving to drop-off location:", drop_off_pos)
        obs, reward, done = move(env, task, from_room=object_pos, to_room=drop_off_pos)
        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # Step 4: Place the object
        print("[Task] Placing the object at:", drop_off_pos)
        obs, reward, done = place(env, task, target_pos=drop_off_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()