def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'object_1', 'object_2', etc.
        object_names = list(positions.keys())
        if not object_names:
            print("No objects available to manipulate.")
            return

        # Dynamically select the first object to pick up
        object_to_pick_up = object_names[0]
        object_pos = positions[object_to_pick_up]
        print(f"[Task] Manipulating {object_to_pick_up} at: {object_pos}")

        # Move to the object's position
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Pick the object
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Now, let's assume we want to place the object at a designated location
        target_location = (1.0, 1.0, 0.0)  # Example target location
        print(f"[Task] Placing {object_to_pick_up} at: {target_location}")

        # Move to the target location
        obs, reward, done = move(env, task, from_room=object_pos, to_room=target_location)
        if done:
            print("[Task] Task ended after moving to the target location!")
            return

        # Place the object
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()