def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['ball1']
        object_2_pos = positions['ball2']
        robot_initial_pos = positions['robot']

        # Move robot to the initial position
        print("[Task] Moving robot to initial position.")
        obs, reward, done = move(env, robot_initial_pos, robot_initial_pos)

        # Check if the robot has reached the initial position
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Pick up the first object
        print("[Task] Picking up object 1 at:", object_1_pos)
        obs, reward, done = pick(env, task, target_pos=object_1_pos)

        if done:
            print("[Task] Task ended after picking object 1!")
            return

        # Place the first object in a new location (for example, object_2_pos)
        print("[Task] Placing object 1 at:", object_2_pos)
        obs, reward, done = place(env, task, target_pos=object_2_pos)

        if done:
            print("[Task] Task ended after placing object 1!")
            return

        # Now pick up the second object
        print("[Task] Picking up object 2 at:", object_2_pos)
        obs, reward, done = pick(env, task, target_pos=object_2_pos)

        if done:
            print("[Task] Task ended after picking object 2!")
            return

        # Finally, place the second object in a designated location (for example, robot_initial_pos)
        print("[Task] Placing object 2 at:", robot_initial_pos)
        obs, reward, done = place(env, task, target_pos=robot_initial_pos)

        if done:
            print("[Task] Task ended after placing object 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()