def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        rooma_pos = positions['rooma']
        roomb_pos = positions['roomb']

        # === Example Task Plan ===
        # 1) Move to the location of ball1
        print("[Task] Moving to the location of ball1.")
        obs, reward, done = move(env, rooma_pos, ball1_pos)
        if done:
            print("[Task] Task ended while moving to ball1!")
            return

        # 2) Pick up ball1
        print("[Task] Picking up ball1.")
        obs, reward, done = pick(env, task, target_pos=ball1_pos)
        if done:
            print("[Task] Task ended after picking up ball1!")
            return

        # 3) Move to the disposal location (roomb)
        print("[Task] Moving to the disposal location (roomb).")
        obs, reward, done = move(env, ball1_pos, roomb_pos)
        if done:
            print("[Task] Task ended while moving to roomb!")
            return

        # 4) Place ball1 in the disposal location
        print("[Task] Placing ball1 in the disposal location.")
        obs, reward, done = place(env, task, target_pos=roomb_pos)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # 5) Move to the location of ball2
        print("[Task] Moving to the location of ball2.")
        obs, reward, done = move(env, roomb_pos, ball2_pos)
        if done:
            print("[Task] Task ended while moving to ball2!")
            return

        # 6) Pick up ball2
        print("[Task] Picking up ball2.")
        obs, reward, done = pick(env, task, target_pos=ball2_pos)
        if done:
            print("[Task] Task ended after picking up ball2!")
            return

        # 7) Move to the disposal location (roomb)
        print("[Task] Moving to the disposal location (roomb).")
        obs, reward, done = move(env, ball2_pos, roomb_pos)
        if done:
            print("[Task] Task ended while moving to roomb!")
            return

        # 8) Place ball2 in the disposal location
        print("[Task] Placing ball2 in the disposal location.")
        obs, reward, done = place(env, task, target_pos=roomb_pos)
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()