def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object "tomato2" and a location "table"
        tomato_pos = positions['tomato2']
        table_pos = positions['table']

        # Step 1: Move to the table
        print("[Task] Moving to the table at:", table_pos)
        obs, reward, done = move(env, "robot", "current_location", table_pos)
        if done:
            print("[Task] Task ended while moving to the table!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking up the tomato at:", tomato_pos)
        obs, reward, done = pick(env, task, target_pos=tomato_pos)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Place the tomato back on the table
        print("[Task] Placing the tomato back on the table at:", table_pos)
        obs, reward, done = place(env, task, target_pos=table_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()