def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a tomato object to pick
        tomato_pos = positions['tomato']
        robot_pos = positions['robot']

        # Move to the tomato's position
        print("[Task] Moving to the tomato's position:", tomato_pos)
        obs, reward, done = move(env, robot_pos, tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Pick the tomato
        print("[Task] Picking the tomato at:", tomato_pos)
        obs, reward, done = pick(env, task, target_pos=tomato_pos)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Move to the drop-off location (assuming a drop-off position is known)
        drop_off_pos = positions['drop_off']
        print("[Task] Moving to the drop-off position:", drop_off_pos)
        obs, reward, done = move(env, tomato_pos, drop_off_pos)
        if done:
            print("[Task] Task ended after moving to the drop-off!")
            return

        # Place the tomato at the drop-off location
        print("[Task] Placing the tomato at:", drop_off_pos)
        obs, reward, done = place(env, task, target_pos=drop_off_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()