def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a plate object to manipulate
        plate_pos = positions['plate']  # Update this based on the actual object names

        # Step 1: Move to the plate's location
        print("[Task] Moving to the plate's location:", plate_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 2: Pick the plate
        print("[Task] Picking the plate at:", plate_pos)
        obs, reward, done = pick(env, task, target_pos=plate_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Step 3: Move to a new location to place the plate
        new_location = 'roomb'  # Define the new location for placing the plate
        print("[Task] Moving to the new location:", new_location)
        obs, reward, done = move(env, 'rooma', new_location)  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to the new location!")
            return

        # Step 4: Place the plate in the new location
        print("[Task] Placing the plate at:", new_location)
        obs, reward, done = place(env, task, target_pos=new_location)
        if done:
            print("[Task] Task ended after placing the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()