def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'ball1' to pick and place
        object_1_pos = positions['ball1']
        target_location = 'target_room'  # Replace with actual target location

        # Step 1: Move to the object's location
        print("[Task] Moving to object location:", object_1_pos)
        obs, reward, done = move(env, task, 'current_room', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # Step 2: Pick the object
        print("[Task] Picking up the object at:", object_1_pos)
        obs, reward, done = pick(env, task, 'ball1', object_1_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the target location
        print("[Task] Moving to target location:", target_location)
        obs, reward, done = move(env, task, object_1_pos, target_location)
        if done:
            print("[Task] Task ended after moving to target location!")
            return

        # Step 4: Place the object at the target location
        print("[Task] Placing the object at:", target_location)
        obs, reward, done = place(env, task, target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()