def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to pick and a location to place them
        object_1_pos = positions['tomato1']
        object_2_pos = positions['tomato2']
        drop_location = positions['plate']

        # Check if the objects exist in the environment
        objects_in_env = task.get_objects()
        if 'tomato1' not in objects_in_env or 'tomato2' not in objects_in_env:
            print("One or both objects are not found in the environment. Exiting task.")
            return

        # Step 1: Approach and pick the first object (tomato1)
        print("[Task] Manipulating tomato1 at:", object_1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating tomato1!")
            return

        # Step 2: Place the first object (tomato1) on the plate
        print("[Task] Placing tomato1 on the plate at:", drop_location)
        obs, reward, done = place(
            env,
            task,
            target_pos=drop_location
        )
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 3: Approach and pick the second object (tomato2)
        print("[Task] Manipulating tomato2 at:", object_2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating tomato2!")
            return

        # Step 4: Place the second object (tomato2) on the plate
        print("[Task] Placing tomato2 on the plate at:", drop_location)
        obs, reward, done = place(
            env,
            task,
            target_pos=drop_location
        )
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()