def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided context
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # Step 1: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended while moving to the plate!")
            return

        # Step 2: Pick the plate
        print("[Task] Picking the plate at:", plate_pos)
        obs, reward, done = pick(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Step 3: Move to the first tomato
        print("[Task] Moving to the first tomato at:", tomato1_pos)
        obs, reward, done = move(env, 'roomb', 'roomc')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended while moving to the first tomato!")
            return

        # Step 4: Place the plate on the first tomato
        print("[Task] Placing the plate on the first tomato at:", tomato1_pos)
        obs, reward, done = place(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after placing the plate on the first tomato!")
            return

        # Step 5: Move to the second tomato
        print("[Task] Moving to the second tomato at:", tomato2_pos)
        obs, reward, done = move(env, 'roomc', 'roomd')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended while moving to the second tomato!")
            return

        # Step 6: Place the plate on the second tomato
        print("[Task] Placing the plate on the second tomato at:", tomato2_pos)
        obs, reward, done = place(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after placing the plate on the second tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()