def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object 'tomato1' to manipulate
        tomato1_pos = positions['tomato1']
        plate_pos = positions['plate']

        # Step 1: Move to the location of the tomato
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'room_a', 'room_a')  # Assuming the robot is already in 'room_a'
        
        if done:
            print("[Task] Task ended while moving to tomato1!")
            return

        # Step 2: Pick up the tomato
        print("[Task] Picking up tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)

        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the plate location
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Move to another room where the plate is located
        
        if done:
            print("[Task] Task ended while moving to plate!")
            return

        # Step 4: Place the tomato on the plate
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)

        if done:
            print("[Task] Task ended after placing tomato1 on plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()