def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: ball1 and ball2
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # 1) Approach and manipulate ball1
        print("[Task] Manipulating ball1 at:", ball1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=ball1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating ball1!")
            return

        # 2) Place ball1 in a new location (e.g., ball2's position)
        print("[Task] Placing ball1 at:", ball2_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=ball2_pos
        )
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # 3) Approach and manipulate ball2
        print("[Task] Manipulating ball2 at:", ball2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=ball2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating ball2!")
            return

        # 4) Place ball2 in a new location (e.g., original position of ball1)
        print("[Task] Placing ball2 at:", ball1_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=ball1_pos
        )
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()