def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'tomato'
        target_object = 'tomato'
        if target_object not in positions:
            print(f"Error: Target object '{target_object}' not found in environment.")
            return

        target_pos = positions[target_object]

        # Move to the object's location
        print(f"[Task] Moving to the location of {target_object} at:", target_pos)
        obs, reward, done = move(env, task, obs.robot_position, target_pos)
        if done:
            print("[Task] Task ended after moving to the object location!")
            return

        # Pick the object
        print(f"[Task] Picking up {target_object}...")
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to a designated drop-off location (assuming we have a drop-off position)
        drop_off_location = (1, 1, 0)  # Example drop-off position
        print(f"[Task] Moving to drop-off location at:", drop_off_location)
        obs, reward, done = move(env, task, target_pos, drop_off_location)
        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # Place the object at the drop-off location
        print(f"[Task] Placing {target_object} at drop-off location...")
        obs, reward, done = place(env, task, target_object, drop_off_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()