def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'ball1' and 'ball2' in the environment
        object_1_pos = positions.get('ball1')
        object_2_pos = positions.get('ball2')

        # Check if the objects are present in the environment
        if object_1_pos is None:
            print("Warning: ball1 is not present in the environment.")
        else:
            print("[Task] Manipulating ball1 at:", object_1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating ball1!")
                return

        if object_2_pos is None:
            print("Warning: ball2 is not present in the environment.")
        else:
            print("[Task] Manipulating ball2 at:", object_2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating ball2!")
                return

        # Place the objects back to their original positions
        if object_1_pos is not None:
            print("[Task] Placing ball1 back at:", object_1_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=object_1_pos
            )
            if done:
                print("[Task] Task ended after placing ball1!")
                return

        if object_2_pos is not None:
            print("[Task] Placing ball2 back at:", object_2_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=object_2_pos
            )
            if done:
                print("[Task] Task ended after placing ball2!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()