def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick and a drop location
        ball_pos = positions['ball1']  # Example object
        drop_pos = positions['roomb']   # Example drop location

        # Check if the ball is present in the environment
        if not task.get_state().get('at', {}).get('ball1', False):
            print("Ball is not present in the environment.")
            return

        # Step 1: Approach and pick the ball
        print("[Task] Manipulating ball at:", ball_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=ball_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 2: Place the ball in the drop location
        print("[Task] Placing ball at:", drop_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=drop_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()