def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'ball1' and 'ball2' in the environment
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # Check if the robot is at the initial position
        if not obs.robot_at(robot_pos):
            print("[Task] Moving robot to initial position...")
            obs, reward, done = move(env, robot_pos, robot_pos)
            if done:
                print("[Task] Task ended after moving robot!")
                return

        # Check if ball1 is available and pick it up
        if 'ball1' in task.get_objects():
            print("[Task] Picking up ball1...")
            obs, reward, done = pick(env, task, target_pos=ball1_pos)
            if done:
                print("[Task] Task ended after picking ball1!")
                return
        else:
            print("Error: ball1 not found in the environment.")
            return

        # Move to the location to place ball1
        print("[Task] Moving to place ball1...")
        obs, reward, done = move(env, robot_pos, 'place_location')
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # Place ball1 at the designated location
        print("[Task] Placing ball1...")
        obs, reward, done = place(env, task, target_pos='place_location')
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # Check if ball2 is available and pick it up
        if 'ball2' in task.get_objects():
            print("[Task] Picking up ball2...")
            obs, reward, done = pick(env, task, target_pos=ball2_pos)
            if done:
                print("[Task] Task ended after picking ball2!")
                return
        else:
            print("Error: ball2 not found in the environment.")
            return

        # Move to the location to place ball2
        print("[Task] Moving to place ball2...")
        obs, reward, done = move(env, robot_pos, 'place_location')
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # Place ball2 at the designated location
        print("[Task] Placing ball2...")
        obs, reward, done = place(env, task, target_pos='place_location')
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()