def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['object_1']  # Replace with actual object names
        object_2_pos = positions['object_2']  # Replace with actual object names

        # Step 1: Move to the location of object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'room_a', 'room_a')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to object_1!")
            return

        # Step 2: Pick object_1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the location of object_2
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to object_2!")
            return

        # Step 4: Pick object_2
        print("[Task] Picking object_2...")
        obs, reward, done = pick(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # Step 5: Place object_1 on a plate (assuming a plate position is known)
        plate_pos = positions['plate']  # Replace with actual plate position
        print("[Task] Placing object_1 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 6: Place object_2 on the plate
        print("[Task] Placing object_2 on the plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()