def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'tomato' and its position
        target_object = 'tomato'
        if target_object not in positions:
            print(f"[Task] {target_object} not found in the environment.")
            return

        target_pos = positions[target_object]
        print(f"[Task] Target object '{target_object}' found at position: {target_pos}")

        # Check if the robot is at the correct location to pick the object
        robot_position = obs.robot_position  # Assuming this gives the robot's current position
        if np.linalg.norm(np.array(robot_position) - np.array(target_pos)) > 1.0:
            print("[Task] Moving robot to the target object's location.")
            # Move the robot to the target object's location
            obs, reward, done = move(env, robot_position, target_pos)
            if done:
                print("[Task] Task ended while moving to the target object!")
                return

        # Attempt to pick the object
        print(f"[Task] Attempting to pick up the object '{target_object}'.")
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after attempting to pick the object!")
            return

        # If the object is successfully picked, we can place it somewhere
        print(f"[Task] Placing the object '{target_object}' at a new location.")
        new_location = (target_pos[0] + 1, target_pos[1], target_pos[2])  # Example new location
        obs, reward, done = place(env, task, new_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()