def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        object_1_pos = positions['ball1']  # Assuming 'ball1' is the object to pick
        object_2_pos = positions['ball2']  # Assuming 'ball2' is the object to place

        # Check if the objects are present before attempting to pick
        if 'ball1' in obs.objects:
            print("[Task] Manipulating ball1 at:", object_1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating ball1!")
                return
        else:
            print("Object 'ball1' not found in observation. Skipping task.")
            return

        # After picking, check if the robot is holding the object
        if 'ball1' in obs.objects and not obs.handempty:
            print("[Task] Placing ball1 at:", object_2_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=object_2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing ball1!")
                return
        else:
            print("Cannot place ball1 as it is not being held.")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()