def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'ball1' in the environment
        object_1_pos = positions['ball1']
        robot_pos = positions['robot']

        # Check if the object is at the robot's location before picking
        if obs['at']['ball1'] == robot_pos and obs['handempty']:
            print("[Task] Manipulating ball1 at:", object_1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking ball1!")
                return
        else:
            print("[Task] ball1 is not in the correct position or the hand is not empty.")

        # Assuming we want to place the object in a specific location
        target_location = positions['target_location']
        if obs['holding']['ball1']:
            print("[Task] Placing ball1 at:", target_location)
            obs, reward, done = place(
                env,
                task,
                target_pos=target_location
            )
            if done:
                print("[Task] Task ended after placing ball1!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()