def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball and a room in the environment
        ball_pos = positions['ball1']  # Replace with actual object name
        room_pos = positions['rooma']   # Replace with actual room name

        # Step 1: Move to the room where the ball is located
        print("[Task] Moving to room where the ball is located.")
        obs, reward, done = move(env, 'rooma', 'rooma')  # Adjust parameters as needed
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick up the ball
        print("[Task] Picking up the ball.")
        obs, reward, done = pick(env, 'ball1', 'rooma')  # Adjust parameters as needed
        if done:
            print("[Task] Task ended after picking up the ball!")
            return

        # Step 3: Place the ball in a designated location (e.g., another room)
        print("[Task] Placing the ball in the designated location.")
        obs, reward, done = place(env, 'ball1', 'roomb')  # Adjust parameters as needed
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()