import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions for the drawers
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']

        # === Execute Plan ===
        # Step 1: Pick the drawer from the bottom anchor position
        print("[Task] Picking the bottom drawer...")
        obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Task ended after picking the bottom drawer!")

        # Step 2: Pull the bottom drawer
        print("[Task] Pulling the bottom drawer if not locked...")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Task ended after pulling the bottom drawer!")

        # Step 3: Pick the middle drawer from the middle anchor position
        print("[Task] Picking the middle drawer...")
        obs, reward, done = pick(env, task, target_pos=middle_anchor_pos)
        if done:
            print("[Task] Task ended after picking the middle drawer!")

        # Step 4: Pull the middle drawer
        print("[Task] Pulling the middle drawer if not locked...")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Task ended after pulling the middle drawer!")

        # Step 5: Pick the top drawer from the top anchor position
        print("[Task] Picking the top drawer...")
        obs, reward, done = pick(env, task, target_pos=top_anchor_pos)
        if done:
            print("[Task] Task ended after picking the top drawer!")

        # Step 6: Pull the top drawer
        print("[Task] Pulling the top drawer if not locked...")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Task ended after pulling the top drawer!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()