import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Import pre-defined skills (pick, place, move, rotate, pull)

from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # First step: pick the bottom drawer
        obs, reward, done = pick(
            env,
            task,
            target_pos=positions['bottom_anchor_pos'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return

        # Second step: pull the bottom drawer
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.2,  # Assuming a reasonable distance to fully open the drawer
            pull_axis='y',
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
        if done:
            print("[Task] Drawer opened successfully!")
        else:
            print("[Task] The drawer could not be opened.")

        # Third step: pick the middle drawer
        obs, reward, done = pick(
            env,
            task,
            target_pos=positions['middle_anchor_pos'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the middle drawer!")
            return

        # Fourth step: pull the middle drawer
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.2,  # Assuming a reasonable distance to fully open the drawer
            pull_axis='y',
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
        if done:
            print("[Task] Middle drawer opened successfully!")
        else:
            print("[Task] The middle drawer could not be opened.")

        # Fifth step: pick the top drawer
        obs, reward, done = pick(
            env,
            task,
            target_pos=positions['top_anchor_pos'],
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the top drawer!")
            return

        # Sixth step: pull the top drawer
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.2,  # Assuming a reasonable distance to fully open the drawer
            pull_axis='y',
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
        if done:
            print("[Task] Top drawer opened successfully!")
        else:
            print("[Task] The top drawer could not be opened.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()