import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the positions for the specified drawers
        bottom_anchor_pos = positions['bottom_anchor_pos']

        # === Execute Task Plan ===
        # Step 1: Move to anchor position for the bottom drawer and pick it
        print("[Task] Picking from bottom drawer...")
        obs, reward, done = pick(
            env,
            task,
            target_pos=bottom_anchor_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended after picking!")
            return

        # Step 2: Pull the bottom drawer to open it
        print("[Task] Pulling to open the bottom drawer...")
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.3,  # Adjust distance based on the simulation scale
            pull_axis='-y',  # Assuming the drawer pulls out along the -y direction
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
        if done:
            print("[Task] Ended after pulling!")
            return
        
        print("[Task] Drawer opened successfully!")
        
    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()