import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Predefined skills/functions
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Define object positions for referencing later in the code
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']

        # === Execute the Task Plan ===
        
        # Step 1: Pick the bottom drawer (anchor position)
        print("[Task] Picking the bottom drawer at:", bottom_anchor_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=bottom_anchor_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task Error] Failed to pick bottom drawer: {e}")
            return
        
        if done:
            print("[Task] Picked the bottom drawer successfully!")
        else:
            print("[Task] Picking bottom drawer was not completed!")

        # Step 2: Pull the bottom drawer
        print("[Task] Pulling open the bottom drawer.")
        try:
            obs, reward, done = pull(
                env,
                task,
                pull_distance=0.1,  # Assume a distance to pull the drawer
                pull_axis='y',  # Assume pulling along y-axis
                max_steps=100,
                threshold=0.01,
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task Error] Failed to pull bottom drawer: {e}")
            return

        if done:
            print("[Task] Pulled the bottom drawer open successfully!")
        else:
            print("[Task] Pulling bottom drawer was not completed!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()