def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'
        drawer = 'drawer'

        # Check if the gripper and drawer exist in the environment
        if gripper not in positions or drawer not in positions:
            print("Error: Required objects (gripper, drawer) not found in object list.")
            return

        # Get the initial position of the gripper and drawer
        gripper_pos = positions[gripper]
        drawer_pos = positions[drawer]

        # Step 1: Rotate the gripper to the desired angle (e.g., ninety degrees)
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 1, 0])  # Example quaternion for 90 degrees
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 2: Move the gripper to the side position of the drawer
        print("[Task] Moving gripper to side position of the drawer.")
        obs, reward, done = move(env, gripper, gripper_pos, drawer_pos)  # Move to the drawer's side position
        if done:
            print("[Task] Task ended after moving gripper!")
            return

        # Step 3: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, gripper, drawer, drawer_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 4: Pull the drawer to open it
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()