def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and a gripper
        drawer = 'drawer1'  # Replace with actual drawer object name
        gripper = 'gripper1'  # Replace with actual gripper object name
        anchor_pos = 'anchor_pos1'  # Replace with actual anchor position
        side_pos = 'side_pos1'  # Replace with actual side position

        # Step 1: Rotate the gripper to the correct orientation
        print("[Task] Rotating gripper to ninety degrees.")
        rotate(env, task, target_quat=[0, 0, 0, 1])  # Replace with actual quaternion for ninety degrees

        # Step 2: Move to the side position
        print("[Task] Moving gripper to side position.")
        move_to_side(env, gripper, drawer, side_pos)

        # Step 3: Move to the anchor position
        print("[Task] Moving gripper to anchor position.")
        move_to_anchor(env, gripper, drawer, side_pos, anchor_pos)

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, gripper, drawer, anchor_pos)

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()