def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        middle_side_pos = positions['middle_side_pos']
        top_side_pos = positions['top_side_pos']
        waypoint1 = positions['waypoint1']

        # === Task Execution Plan ===
        # Step 1: Move to the bottom anchor position
        print("[Task] Moving to bottom anchor position.")
        obs, reward, done = move(env, task, obs.gripper_pose[:3], bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to bottom anchor position!")
            return

        # Step 2: Pick the bottom drawer
        print("[Task] Picking the bottom drawer.")
        obs, reward, done = pick(env, 'bottom_drawer', bottom_anchor_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return

        # Step 3: Move to the bottom side position
        print("[Task] Moving to bottom side position.")
        obs, reward, done = move(env, task, bottom_anchor_pos, bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to bottom side position!")
            return

        # Step 4: Rotate the gripper to the desired angle
        print("[Task] Rotating the gripper.")
        target_quat = [0, 0, 0, 1]  # Example quaternion for rotation
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 5: Pull the bottom drawer
        print("[Task] Pulling the bottom drawer.")
        obs, reward, done = pull(env, 'bottom_drawer')
        if done:
            print("[Task] Task ended after pulling the bottom drawer!")
            return

        # Step 6: Move to the middle anchor position
        print("[Task] Moving to middle anchor position.")
        obs, reward, done = move(env, task, bottom_side_pos, middle_anchor_pos)
        if done:
            print("[Task] Task ended after moving to middle anchor position!")
            return

        # Step 7: Pick the middle drawer
        print("[Task] Picking the middle drawer.")
        obs, reward, done = pick(env, 'middle_drawer', middle_anchor_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the middle drawer!")
            return

        # Step 8: Move to the middle side position
        print("[Task] Moving to middle side position.")
        obs, reward, done = move(env, task, middle_anchor_pos, middle_side_pos)
        if done:
            print("[Task] Task ended after moving to middle side position!")
            return

        # Step 9: Rotate the gripper to the desired angle
        print("[Task] Rotating the gripper.")
        target_quat = [0, 0, 0, 1]  # Example quaternion for rotation
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 10: Pull the middle drawer
        print("[Task] Pulling the middle drawer.")
        obs, reward, done = pull(env, 'middle_drawer')
        if done:
            print("[Task] Task ended after pulling the middle drawer!")
            return

        # Step 11: Move to the top anchor position
        print("[Task] Moving to top anchor position.")
        obs, reward, done = move(env, task, middle_side_pos, top_anchor_pos)
        if done:
            print("[Task] Task ended after moving to top anchor position!")
            return

        # Step 12: Pick the top drawer
        print("[Task] Picking the top drawer.")
        obs, reward, done = pick(env, 'top_drawer', top_anchor_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the top drawer!")
            return

        # Step 13: Move to the top side position
        print("[Task] Moving to top side position.")
        obs, reward, done = move(env, task, top_anchor_pos, top_side_pos)
        if done:
            print("[Task] Task ended after moving to top side position!")
            return

        # Step 14: Rotate the gripper to the desired angle
        print("[Task] Rotating the gripper.")
        target_quat = [0, 0, 0, 1]  # Example quaternion for rotation
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 15: Pull the top drawer
        print("[Task] Pulling the top drawer.")
        obs, reward, done = pull(env, 'top_drawer')
        if done:
            print("[Task] Task ended after pulling the top drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()