def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the drawer is identified as 'drawer1' and the gripper as 'gripper1'
        drawer = 'drawer1'
        gripper = 'gripper1'
        anchor_position = 'anchor_pos'  # Replace with actual anchor position for the drawer
        side_position = 'side_pos'  # Replace with actual side position for the drawer

        # Step 1: Move to the anchor position of the drawer
        print(f"[Task] Moving {gripper} to the anchor position of {drawer}.")
        obs, reward, done = move_to_anchor(gripper, drawer, anchor_position)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 2: Pick the drawer
        print(f"[Task] Picking {drawer}.")
        obs, reward, done = pick(gripper, drawer, anchor_position)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Move to the side position of the drawer
        print(f"[Task] Moving {gripper} to the side position of {drawer}.")
        obs, reward, done = move_to_side(gripper, drawer, anchor_position, side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 4: Pull the drawer to open it
        print(f"[Task] Pulling {drawer} to open it.")
        obs, reward, done = pull(gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()