def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        side_pos_bottom = positions['side_pos-bottom']
        side_pos_middle = positions['side_pos-middle']
        side_pos_top = positions['side_pos-top']
        drawer = positions['drawer']

        # === Task Execution Plan ===
        # Step 1: Rotate the gripper to the correct orientation
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 1, 0])  # Assuming this is the target quaternion for 90 degrees
        if done:
            print("[Task] Task ended during rotation!")
            return

        # Step 2: Move to the side position (bottom)
        print("[Task] Moving to side position (bottom).")
        obs, reward, done = move(env, 'gripper', 'current_position', side_pos_bottom)
        if done:
            print("[Task] Task ended during moving to side position!")
            return

        # Step 3: Pick the drawer from the side position
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, side_pos_bottom, 'gripper')
        if done:
            print("[Task] Task ended during picking!")
            return

        # Step 4: Move to the anchor position (middle)
        print("[Task] Moving to anchor position (middle).")
        obs, reward, done = move(env, 'gripper', side_pos_bottom, side_pos_middle)
        if done:
            print("[Task] Task ended during moving to anchor position!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper', drawer)
        if done:
            print("[Task] Task ended during pulling!")
            return

        # Step 6: Move to the side position (top)
        print("[Task] Moving to side position (top).")
        obs, reward, done = move(env, 'gripper', side_pos_middle, side_pos_top)
        if done:
            print("[Task] Task ended during moving to side position (top)!")
            return

        # Step 7: Place the drawer back
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, drawer, side_pos_top, 'gripper')
        if done:
            print("[Task] Task ended during placing!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()