import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the positions for the drawers
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']

        # === Execute the Plan ===
        # Step 1: Rotate the gripper to the correct orientation
        obs, reward, done = rotate(env, task, target_quat=np.array([0, 0, 0, 1]))  # Assuming zero rotation is needed
        if done:
            print("[Task] Task ended after rotating!")
            return

        # Step 2: Move to the side position of the bottom drawer
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 3: Move to the anchor position of the bottom drawer
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 4: Pick the bottom drawer
        obs, reward, done = pick(env, task, "bottom", bottom_anchor_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the bottom drawer to open it
        obs, reward, done = pull(env, task, "gripper", "bottom")
        if done:
            print("[Task] Task completed successfully! Drawer opened.")
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()