(define (domain open-drawer)
  (:requirements :strips :typing :negative-preconditions :equality :disjunctive-preconditions)
  (:types
    drawer gripper position angle - object
  )
  (:predicates
    (is-locked ?d - drawer)
    (is-open ?d - drawer)
    (rotated ?g - gripper ?a - angle)
    (at ?g - gripper ?p - position)
    (holding ?g - gripper ?d - drawer)
    (is-side-pos ?p - position ?d - drawer)
    (is-anchor-pos ?p - position ?d - drawer)
  )
  (:action rotate
    :parameters (?g - gripper ?from - angle ?to - angle)
    :precondition (and
      (rotated ?g ?from)
      (not (= ?from ?to))
    )
    :effect (and
      (not (rotated ?g ?from))
      (rotated ?g ?to)
    )
  )
  (:action move-to-side
    :parameters (?g - gripper ?d - drawer ?from ?to - position)
    :precondition (and
      (at ?g ?from)
      (is-side-pos ?to ?d)
      (not (at ?g ?to))
      (rotated ?g ninety_deg)
    )
    :effect (and
      (at ?g ?to)
      (not (at ?g ?from))
    )
  )
  (:action move-to-anchor
    :parameters (?g - gripper ?d - drawer ?from ?to - position)
    :precondition (and
      (is-side-pos ?from ?d)
      (is-anchor-pos ?to ?d)
      (at ?g ?from)
      (not (at ?g ?to))
    )
    :effect (and
      (at ?g ?to)
      (not (at ?g ?from))
    )
  )
  (:action pick
    :parameters (?g - gripper ?d - drawer ?p - position)
    :precondition (and
      (at ?g ?p)
      (is-anchor-pos ?p ?d)
      (not (holding ?g ?d))
    )
    :effect (holding ?g ?d)
  )
  (:action pull
    :parameters (?g - gripper ?d - drawer)
    :precondition (and
      (holding ?g ?d)
      (not (is-locked ?d))
      (not (is-open ?d))
    )
    :effect (is-open ?d)
  )
)