def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a tomato and a bin in the environment
        tomato_pos = positions['tomato']
        bin_pos = positions['bin']

        # Step 1: Move to the tomato
        print("[Task] Moving to the tomato at:", tomato_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended while moving to the tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato...")
        obs, reward, done = pick(env, task, target_pos=tomato_pos)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended while moving to the bin!")
            return

        # Step 4: Place the tomato in the bin
        print("[Task] Placing the tomato in the bin...")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing the tomato in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()